/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2276;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5847;
import net.minecraft.class_6625;
import twilightforest.block.TFBlocks;
import twilightforest.entity.TFEntities;
import twilightforest.loot.TFTreasure;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.world.components.structures.TFMaze;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.registration.TFFeature;

public class HedgeMazeComponent
extends TFStructureComponentOld {
    private static final int MSIZE = 16;
    private static final int RADIUS = 25;
    private static final int DIAMETER = 50;
    private static final int FLOOR_LEVEL = 0;

    public HedgeMazeComponent(class_6625 ctx, class_2487 nbt) {
        super(TFFeature.TFHedge, nbt);
        this.field_15315 = BoundingBoxUtils.NBTToBoundingBox(nbt);
    }

    public HedgeMazeComponent(TFFeature feature, int i, int x, int y, int z) {
        super(TFFeature.TFHedge, feature, i, x, y, z);
        this.method_14926(class_2350.field_11035);
        this.field_15315 = feature.getComponentToAddBoundingBox(x, y, z, -25, -3, -25, 50, 10, 50, class_2350.field_11035);
    }

    public void method_14931(class_5281 world, class_5138 manager, class_2794 generator, Random rand, class_3341 sbb, class_1923 chunkPosIn, class_2338 blockPos) {
        TFMaze maze = new TFMaze(16, 16);
        maze.oddBias = 2;
        maze.torchBlockState = ((class_2248)TFBlocks.FIREFLY.get()).method_9564();
        maze.wallBlockState = ((class_2248)TFBlocks.HEDGE.get()).method_9564();
        maze.type = 4;
        maze.tall = 3;
        maze.roots = 3;
        maze.setSeed(world.method_8412() + (long)this.field_15315.method_35415() * (long)this.field_15315.method_35417());
        for (int fx = 0; fx <= 50; ++fx) {
            for (int fz = 0; fz <= 50; ++fz) {
                this.method_14917(world, class_2246.field_10219.method_9564(), fx, -1, fz, sbb);
            }
        }
        class_2680 northJacko = (class_2680)class_2246.field_10009.method_9564().method_11657((class_2769)class_2276.field_10748, (Comparable)class_2350.field_11043);
        class_2680 southJacko = (class_2680)class_2246.field_10009.method_9564().method_11657((class_2769)class_2276.field_10748, (Comparable)class_2350.field_11035);
        class_2680 westJacko = (class_2680)class_2246.field_10009.method_9564().method_11657((class_2769)class_2276.field_10748, (Comparable)class_2350.field_11039);
        class_2680 eastJacko = (class_2680)class_2246.field_10009.method_9564().method_11657((class_2769)class_2276.field_10748, (Comparable)class_2350.field_11034);
        this.method_14917(world, westJacko, 0, 0, 24, sbb);
        this.method_14917(world, westJacko, 0, 0, 29, sbb);
        this.method_14917(world, eastJacko, 50, 0, 24, sbb);
        this.method_14917(world, eastJacko, 50, 0, 29, sbb);
        this.method_14917(world, northJacko, 24, 0, 0, sbb);
        this.method_14917(world, northJacko, 29, 0, 0, sbb);
        this.method_14917(world, southJacko, 24, 0, 50, sbb);
        this.method_14917(world, southJacko, 29, 0, 50, sbb);
        int nrooms = 5;
        int[] rcoords = new int[nrooms * 2];
        for (int i = 0; i < nrooms; ++i) {
            int rz;
            int rx;
            while (this.isNearRoom(rx = maze.rand.nextInt(14) + 1, rz = maze.rand.nextInt(14) + 1, rcoords)) {
            }
            maze.carveRoom1(rx, rz);
            rcoords[i * 2] = rx;
            rcoords[i * 2 + 1] = rz;
        }
        maze.generateRecursiveBacktracker(0, 0);
        maze.add4Exits();
        maze.copyToStructure(world, manager, generator, 1, 0, 1, this, sbb);
        this.decorate3x3Rooms(world, rcoords, sbb);
    }

    private boolean isNearRoom(int dx, int dz, int[] rcoords) {
        if (dx == 1 && dz == 1) {
            return true;
        }
        for (int i = 0; i < rcoords.length / 2; ++i) {
            int rx = rcoords[i * 2];
            int rz = rcoords[i * 2 + 1];
            if (rx == 0 && rz == 0 || Math.abs(dx - rx) >= 3 || Math.abs(dz - rz) >= 3) continue;
            return true;
        }
        return false;
    }

    private void decorate3x3Rooms(class_5281 world, int[] rcoords, class_3341 sbb) {
        for (int i = 0; i < rcoords.length / 2; ++i) {
            int dx = rcoords[i * 2];
            int dz = rcoords[i * 2 + 1];
            dx = dx * 3 + 3;
            dz = dz * 3 + 3;
            this.decorate3x3Room(world, dx, dz, sbb);
        }
    }

    private void decorate3x3Room(class_5281 world, int x, int z, class_3341 sbb) {
        Random roomRNG = new Random(world.method_8412() ^ (long)(x + z));
        this.roomJackO(world, roomRNG, x, z, 8, sbb);
        if (roomRNG.nextInt(4) == 0) {
            this.roomJackO(world, roomRNG, x, z, 8, sbb);
        }
        this.roomSpawner(world, roomRNG, x, z, 8, sbb);
        this.roomTreasure(world, roomRNG, x, z, 8, sbb);
        if (roomRNG.nextInt(4) == 0) {
            this.roomTreasure(world, roomRNG, x, z, 8, sbb);
        }
    }

    private void roomSpawner(class_5281 world, Random rand, int x, int z, int diameter, class_3341 sbb) {
        int rx = x + rand.nextInt(diameter) - diameter / 2;
        int rz = z + rand.nextInt(diameter) - diameter / 2;
        class_1299 mobID = switch (rand.nextInt(3)) {
            case 1 -> (class_1299)TFEntities.SWARM_SPIDER.get();
            case 2 -> (class_1299)TFEntities.HOSTILE_WOLF.get();
            default -> (class_1299)TFEntities.HEDGE_SPIDER.get();
        };
        this.setSpawner(world, rx, 0, rz, sbb, mobID);
    }

    private void roomTreasure(class_5281 world, Random rand, int x, int z, int diameter, class_3341 sbb) {
        int rx = x + rand.nextInt(diameter) - diameter / 2;
        int rz = z + rand.nextInt(diameter) - diameter / 2;
        this.placeTreasureAtCurrentPosition(world, rx, 0, rz, TFTreasure.HEDGE_MAZE, sbb);
    }

    private void roomJackO(class_5281 world, Random rand, int x, int z, int diameter, class_3341 sbb) {
        int rx = x + rand.nextInt(diameter) - diameter / 2;
        int rz = z + rand.nextInt(diameter) - diameter / 2;
        this.method_14917(world, (class_2680)class_2246.field_10009.method_9564().method_11657((class_2769)class_2276.field_10748, (Comparable)class_2350.method_10139((int)rand.nextInt(4))), rx, 0, rz, sbb);
    }

    @Override
    public class_5847 method_33882() {
        return class_5847.field_28924;
    }

    @Override
    protected void method_14943(class_6625 ctx, class_2487 tagCompound) {
        super.method_14943(ctx, tagCompound);
        BoundingBoxUtils.boundingBoxToExistingNBT(this.field_15315, tagCompound);
    }
}

